import { jsx } from "react/jsx-runtime";
import { preventDefault, stopEventPropagation } from "@tldraw/editor";
import { forwardRef } from "react";
const TextArea = forwardRef(function TextArea2({
  isEditing,
  text,
  handleFocus,
  handleChange,
  handleKeyDown,
  handleBlur,
  handleInputPointerDown,
  handleDoubleClick
}, ref) {
  return /* @__PURE__ */ jsx(
    "textarea",
    {
      ref,
      className: "tl-text tl-text-input",
      name: "text",
      tabIndex: -1,
      readOnly: !isEditing,
      autoComplete: "off",
      autoCapitalize: "off",
      autoCorrect: "off",
      autoSave: "off",
      placeholder: "",
      spellCheck: "true",
      wrap: "off",
      dir: "auto",
      defaultValue: text,
      onFocus: handleFocus,
      onChange: handleChange,
      onKeyDown: handleKeyDown,
      onBlur: handleBlur,
      onTouchEnd: stopEventPropagation,
      onContextMenu: isEditing ? stopEventPropagation : void 0,
      onPointerDown: handleInputPointerDown,
      onDoubleClick: handleDoubleClick,
      onDragStart: preventDefault
    }
  );
});
export {
  TextArea
};
//# sourceMappingURL=TextArea.mjs.map
